<?php
/**
 * @package Helix Ultimate Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2025 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */

defined ('_JEXEC') or die();

use HelixUltimate\Framework\Platform\Helper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Layout\LayoutHelper;

HTMLHelper::addIncludePath(JPATH_COMPONENT . '/helpers');

$app = Factory::getApplication();

$this->category->text = $this->category->description;
$app->triggerEvent('onContentPrepare', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$this->category->description = $this->category->text;

$results = $app->triggerEvent('onContentAfterTitle', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$afterDisplayTitle = trim(implode("\n", $results));

$results = $app->triggerEvent('onContentBeforeDisplay', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$beforeDisplayContent = trim(implode("\n", $results));

$results = $app->triggerEvent('onContentAfterDisplay', array($this->category->extension . '.categories', &$this->category, &$this->params, 0));
$afterDisplayContent = trim(implode("\n", $results));
$columns = !empty((int) $this->params->get('num_columns')) ? (int) $this->params->get('num_columns') : 3;

$template = HelixUltimate\Framework\Platform\Helper::loadTemplateData();
$blogListType = $template->params->get('blog_list_type') ?? 'default';
?>
<style>.article-list.grid {--columns: <?php echo $columns; ?>;}</style>
<div class="blog<?php echo $this->pageclass_sfx; ?>">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header">
			<h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
		</div>
	<?php endif; ?>

	<?php if ($this->params->get('show_category_title', 1) or $this->params->get('page_subheading')) : ?>
		<h2>
			<?php echo $this->escape($this->params->get('page_subheading')); ?>
			<?php if ($this->params->get('show_category_title')) : ?>
				<span class="subheading-category"><?php echo $this->category->title; ?></span>
			<?php endif; ?>
		</h2>
	<?php endif; ?>

	<?php echo $afterDisplayTitle; ?>

	<?php if ($this->params->get('show_cat_tags', 1) && !empty($this->category->tags->itemTags)) : ?>
		<?php $this->category->tagLayout = new FileLayout('joomla.content.tags'); ?>
		<?php echo $this->category->tagLayout->render($this->category->tags->itemTags); ?>
	<?php endif; ?>

	<?php if ($beforeDisplayContent || $afterDisplayContent || $this->params->get('show_description', 1) || $this->params->def('show_description_image', 1)) : ?>
		<div class="category-desc clearfix">
			<?php if ($this->params->get('show_description_image') && $this->category->getParams()->get('image')) : ?>
				<img src="<?php echo $this->category->getParams()->get('image'); ?>" alt="<?php echo htmlspecialchars($this->category->getParams()->get('image_alt') ?? "", ENT_COMPAT, 'UTF-8'); ?>">
			<?php endif; ?>
			<?php echo $beforeDisplayContent; ?>
			<?php if ($this->params->get('show_description') && $this->category->description) : ?>
				<?php echo HTMLHelper::_('content.prepare', $this->category->description, '', 'com_content.category'); ?>
			<?php endif; ?>
			<?php echo $afterDisplayContent; ?>
		</div>
	<?php endif; ?>

	<?php if (empty($this->lead_items) && empty($this->link_items) && empty($this->intro_items)) : ?>
		<?php if ($this->params->get('show_no_articles', 1)) : ?>
			<p><?php echo Text::_('COM_CONTENT_NO_ARTICLES'); ?></p>
		<?php endif; ?>
	<?php endif; ?>

	<?php $leadingcount = 0; ?>
	<?php if (!empty($this->lead_items)) : ?>
		<div class="article-list articles-leading<?php echo $this->params->get('blog_class_leading'); ?>">
			<?php foreach ($this->lead_items as &$item) : ?>
				<div class="article<?php echo $item->state == 0 ? ' system-unpublished' : null; ?>"
					itemprop="blogPost" itemscope itemtype="https://schema.org/BlogPosting">
					<?php
						$this->item = & $item;
					$this->item->leading = true;
					echo $this->loadTemplate('item');
					?>
				</div>
				<?php $leadingcount++; ?>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>

	<?php
	$introcount = count($this->intro_items);
	$counter = 0;
	?>

	<?php if (!empty($this->intro_items)) : ?>
		<?php $blogClass = $this->params->get('blog_class', ''); ?>
		<?php if ((int) $this->params->get('num_columns') > 1) : ?>
			<?php $blogClass .= 'cols-' . (int) $this->params->get('num_columns'); ?>
		<?php endif; ?>

		<?php if ($blogListType == 'masonry') : ?>
			<?php
			$numCols = (int) $this->params->get('num_columns', 1);
			$orderDown = (int) $this->params->get('multi_column_order', 1); // Flip for Joomla logic
			$introcount = count($this->intro_items);
			$numRows = ceil($introcount / $numCols);
			?>
			<div class="article-list grid">
				<?php for ($row = 0; $row < $numRows; $row++) : ?>
					<?php for ($col = 0; $col < $numCols; $col++) :
						if ($orderDown) {
							$index = $col * $numRows + $row;
						} else {
							$index = $row * $numCols + $col;
						}
						if ($index >= $introcount) {
							continue;
						}
						$item = &$this->intro_items[$index];
					?>
						<div class="article flow" itemprop="blogPost" itemscope itemtype="https://schema.org/BlogPosting">
							<?php
							$this->item = &$item;
							echo LayoutHelper::render('masonry.bloglist', [$item, ($index + 1)], HELIX_LAYOUTS_PATH);
							?>
						</div>
					<?php endfor; ?>
				<?php endfor; ?>
			</div>

		<?php else : ?>
			<div class="article-list">
				<div class="row row-<?php echo $counter + 1; ?> <?php echo $blogClass; ?>">
					<?php
					$numCols = (int) $this->params->get('num_columns', 1);
					$orderDown = (int) !$this->params->get('multi_column_order', 1); // 0 = across → down, 1 = down → across

					// calculate number of rows
					$introcount = count($this->intro_items);
					$numRows = ceil($introcount / $numCols);

					// Create rows and columns with direction support
					for ($row = 0; $row < $numRows; $row++) : ?>
						<div class="row">
							<?php for ($col = 0; $col < $numCols; $col++) :
								if ($orderDown) {
									$index = $col * $numRows + $row;
								} else {
									$index = $row * $numCols + $col;
								}
								if ($index >= $introcount) {
									continue;
								}
								$item = &$this->intro_items[$index];
							?>
								<div class="col-lg-<?php echo round(12 / Helper::SetColumn($numCols, 4)); ?>">
									<div class="article" itemprop="blogPost" itemscope itemtype="https://schema.org/BlogPosting">
										<?php
										$this->item = &$item;
										echo $this->loadTemplate('item');
										?>
									</div>
								</div>
							<?php endfor; ?>
						</div>
					<?php endfor; ?>
				</div>
			</div>
		<?php endif; ?>
	<?php endif; ?>

	<?php if (!empty($this->link_items)) : ?>
		<div class="articles-more mb-4">
			<?php echo $this->loadTemplate('links'); ?>
		</div>
	<?php endif; ?>

	<?php if ($this->maxLevel != 0 && !empty($this->children[$this->category->id])) : ?>
		<div class="cat-children mb-4">
			<?php if ($this->params->get('show_category_heading_title_text', 1) == 1) : ?>
				<h3> <?php echo Text::_('JGLOBAL_SUBCATEGORIES'); ?> </h3>
			<?php endif; ?>
			<?php echo $this->loadTemplate('children'); ?>
		</div>
	<?php endif; ?>

	<?php if (($this->params->def('show_pagination', 1) == 1 || ($this->params->get('show_pagination') == 2)) && ($this->pagination->pagesTotal > 1)) : ?>
		<nav class="pagination-wrapper d-lg-flex justify-content-between w-100">
			<?php echo $this->pagination->getPagesLinks(); ?>
			<?php if ($this->params->def('show_pagination_results', 1)) : ?>
				<div class="pagination-counter text-muted mb-4">
					<?php echo $this->pagination->getPagesCounter(); ?>
				</div>
			<?php endif; ?>
		</nav>
	<?php endif; ?>
</div>
